package com.example.todoapi;

import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class DataLoader implements CommandLineRunner {

    private final UserRepository userRepository;

    public DataLoader(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public void run(String... args) throws Exception {
        // もしユーザーが0人なら（空っぽなら）、初期データを登録する
        if (userRepository.count() == 0) {
            registerUser("自分", "😎");
            registerUser("猫好き", "🐱");
            registerUser("犬派", "🐶");
            registerUser("ペンギン", "🐧");
            System.out.println("★初期データを登録しました！");
        }
    }

    private void registerUser(String name, String icon) {
        User user = new User();
        user.setName(name);
        user.setIcon(icon);
        userRepository.save(user);
    }
}