package com.example.todoapi;

import java.util.List;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/messages")
public class MessageController {

    private final MessageService messageService;

    public MessageController(MessageService messageService) {
        this.messageService = messageService;
    }

    // ★変更: URLから文字列を受け取る
    @GetMapping("/{roomId}")
    public List<Message> getMessages(@PathVariable String roomId) {
        return messageService.getMessagesByRoom(roomId);
    }

   @PostMapping
    public Message postMessage(@RequestBody Message message) {
        // 1. 今の時間を取得 (例: 15:30:45.123)
        LocalTime now = LocalTime.now();
        
        // 2. "HH:mm" (15:30) の形に整形する
        String formattedTime = now.format(DateTimeFormatter.ofPattern("HH:mm"));
        
        // 3. メッセージにセットする
        message.setTime(formattedTime);
        
        // 4. 保存！
        return messageService.saveMessage(message);
    }
}