package com.example.todoapi;

import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MessageService {

    private final MessageRepository messageRepository;

    public MessageService(MessageRepository messageRepository) {
        this.messageRepository = messageRepository;
    }

    // ★変更: String roomId を受け取る
    public List<Message> getMessagesByRoom(String roomId) {
        return messageRepository.findByRoomId(roomId);
    }

    public Message saveMessage(Message message) {
        return messageRepository.save(message);
    }
}