package com.example.todoapi;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;

@RestController
@RequestMapping("/tasks")
public class TaskController {

    private final TaskService taskService;

    public TaskController(TaskService taskService){
        this.taskService = taskService;
    }

    @GetMapping
    public List<Task> getTasks(){
        return taskService.getAllTasks();
    }
    //POSTリクエスト(登録)
    @PostMapping
    public Task postMethodName(@RequestBody Task task) {
        //@RequestBodyはブラウザから送られてきたJSONデータをJavaのTaskオブジェクトに変換するという命令をしている
         return taskService.createTask(task);
    }
    // 既存のコードの下に追加...

    // ★ 更新窓口 (PUT /tasks/{id})
    @PutMapping("/{id}") // URLでIDを受け取る（例: /tasks/1）
    public Task updateTask(@PathVariable Long id, @RequestBody Task task) {
        // @PathVariable: URLに入っている "1" などを変数 id に入れる魔法
        return taskService.updateTask(id, task);
    }

    // ★ 削除窓口 (DELETE /tasks/{id})
    @DeleteMapping("/{id}")
    public void deleteTask(@PathVariable Long id) {
        taskService.deleteTask(id);
    }
} // ← クラスの閉じカッコ
