package com.example.todoapi;

import org.springframework.stereotype.Service;
import java.util.List;

@Service // これはビジネスロジック（実務）を行うクラスですよ、という宣言
public class TaskService {

    private final TaskRepository taskRepository;

    // コンストラクタ（Springが自動でRepositoryを渡してくれる＝DI）
    public TaskService(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    // 全件取得するメソッド
    public List<Task> getAllTasks() {
        return taskRepository.findAll();
    }
    //データ保存のメソッド
    public Task createTask(Task task){
        return taskRepository.save(task);
    }

    // ★ 更新機能 (Update)
    public Task updateTask(Long id, Task newTask) {
        // 1. 指定されたIDのタスクをDBから探す
        // (なければ null を返す簡易実装)
        Task existingTask = taskRepository.findById(id).orElse(null);
        
        if (existingTask == null) {
            return null;
        }

        // 2. 新しい内容で上書きする
        existingTask.setTitle(newTask.getTitle());
        existingTask.setCompleted(newTask.isCompleted());

        // 3. 保存する（IDがすでにあるので、INSERTではなくUPDATEになる）
        return taskRepository.save(existingTask);
    }

    // ★ 削除機能 (Delete)
    public void deleteTask(Long id) {
        taskRepository.deleteById(id);
    }
}