package com.example.todoapi;

import java.util.List;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/users")
public class UserController {

    private final UserRepository userRepository;

    public UserController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    // ★変更: クエリパラメータ (excludeId) を受け取る
    // URL例: GET /users?excludeId=1
    @GetMapping
    public List<User> getUsers(@RequestParam(required = false) Long excludeId) {
        if (excludeId != null) {
            // 指定があれば、その人を除外して返す
            return userRepository.findByIdNot(excludeId);
        }
        // 指定がなければ全員返す（ログイン画面用など）
        return userRepository.findAll();
    }
}